<?php
/*============================================================================*\
|| ########################################################################## ||
|| # Import External Images                                                 # ||
|| # ---------------------------------------------------------------------- # ||
|| # (C) Copyright Y2K Software s.a.s. 2010 - All Rights Reserved.          # ||
|| # This file may not be redistributed in whole or significant part.       # ||
|| ########################################################################## ||
\*============================================================================*/

/**
 * @author Y2K Software
 * @copyright (C) Copyright Y2K Software 2010 - All Rights Reserved
 * @version 1.0.2
 * @link www.pagerobot.com
 */

error_reporting(E_ALL & ~ E_NOTICE);
if(!is_object($vbulletin->db))
{
    exit;
}

if (!$vbulletin->options['mwaextraadmin5_setting_active_imgcache'])
{
    exit;
}

/**
 * iei_cache_registered_images()
 * 
 * Reads all registered images into memory for fast parsing.
 * If you have a large board, you may need to clean out this table from time to time by removing old records.
 * 
 * @return array $images
 */
function iei_cache_registered_images()
{
    global $vbulletin;

    $images = array();
    $SQL = "SELECT oldurl, newurl 
        FROM " . TABLE_PREFIX . "iei_img";
    $rss = $vbulletin->db->query_read($SQL);
    while($rs = $vbulletin->db->fetch_array($rss))
    {
        $images["$rs[oldurl]"] = $rs['newurl'];
    }
    $vbulletin->db->free_result($rss);

    return $images;
}

/**
 * iei_normalize_path()
 * 
 * Avoid strange path names.
 * 
 * @param mixed $path
 * @return mixed $path
 */
function iei_normalize_path($path)
{
    if(substr($path, -1, 1) != '/')
    {
        $path .= '/';
    }
    $path = str_replace('\\', '/', $path);
    if(strpos($path, ':'))
    {
        $path = str_replace('//', '/', $path);
    }

    return $path;
}

/**
 * iei_get_file_index()
 * 
 * Search a new file name.
 * 
 * @param mixed $path
 * @param mixed $extension
 * @return mixed $filename
 */
function iei_get_file_index(&$path, &$extension)
{
    for($i = 1;; $i++)
    {
        $filename = "$path/$i.$extension";
        if(!file_exists($filename))
        {
            return $filename;
        }
    }
}

/**
 * iei_get_file_extension()
 * 
 * Sanitize extension.
 * 
 * @param mixed $value
 * @param mixed $convert
 * @param mixed $extension
 * @return void
 */
function iei_get_file_extension(&$value, &$convert, &$extension)
{
    if(ALWAYS_CONVERT_IMAGES)
    {
        $convert = true;
        $extension = 'jpg';
        return;
    }

    $convert = false;
    $i = strrpos($value, '.');
    if($i === false)
    {
        $convert = true;
        $extension = 'jpg';
        return;
    }

    $extension = substr($value, $i + 1);
    if(strpos($extension, '/') !== false || strpos($extension, '&') !== false)
    {
        $convert = true;
        $extension = 'jpg';
    }

    $extension = strtolower($extension);
}

/**
 * iei_get_contents()
 * 
 * Get file from remote site.
 * 
 * @param mixed $url
 * @return $contents / false on error
 */
function iei_get_contents(&$url)
{
    $ch = 0;
    if(USE_CURL)
    {
        $ch = @curl_init($url);
        curl_setopt($ch, CURLOPT_BINARYTRANSFER, 1);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_FAILONERROR, 1);
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 10);
        curl_setopt($ch, CURLOPT_TIMEOUT, 120);
        curl_setopt($ch, CURLOPT_REFERER, AEI_BBURL . '/');
        curl_setopt($ch, CURLOPT_USERAGENT, AEI_FORUMDOMAIN);
        $contents = @curl_exec($ch);
        @curl_close($ch);
    }
    if(!$ch)
    {
        // If CURL didn't work, try it differently
        $contents = @file_get_contents($imagename);
    }

    return $contents ? $contents : false;
}

// Get iei options
define('USE_CURL', function_exists('curl_init'));
foreach($vbulletin->options as $key => $value)
{
    if(strpos($key, 'iei_') === false)
    {
        continue;
    }
    $$key = $value;
}
define('ALWAYS_CONVERT_IMAGES', $iei_always_convert_images);

// Adjust options
$bburl0 = $vbulletin->options['bburl'];
if($iei_bburl_replacement)
{
    $bburl = $iei_bburl_replacement . '/';
}
else
{
    $bburl = $bburl0 . '/';
}
$iei_imported_images_folder = iei_normalize_path($iei_imported_images_folder);
$iei_ignore = explode("\r\n", $iei_ignore);
$iei_ignore[] = $bburl;
$iei_ignore[] = $bburl0 . '/';
$iei_ignore[] = $iei_imported_images_folder;
if($iei_remove_invalid_images)
{
    $iei_ignore[] = $iei_invalid_image_replacement;
}

// Exclude all new records which have no images at all
$SQL = "UPDATE " . TABLE_PREFIX . "post 
    SET iei_parsed=1
    WHERE iei_parsed=0
        AND NOT pagetext LIKE '%[/IMG]%'";
$vbulletin->db->query_write($SQL);

$mwaimgcache_mwanotforumid = "AND thread.forumid NOT IN (0)";
$iei_ignore_usersp = "AND post.userid NOT IN (0)";

if ($vbulletin->options['mwaimgcache_mwanotforumid'])
{
$mwaimgcache_mwanotforumid = "AND thread.forumid NOT IN (" . $vbulletin->options['mwaimgcache_mwanotforumid'] . ")";
}

if ($vbulletin->options['iei_ignore_users'])
{
$iei_ignore_usersp = "AND post.userid NOT IN (" . $vbulletin->options['iei_ignore_users'] . ")";
}

// For each record with images ...
$cnt = 0;
$SQL = "SELECT post.postid, post.userid, post.dateline, post.pagetext , post.iei_parsed
    FROM " . TABLE_PREFIX . "post AS post
    LEFT JOIN " . TABLE_PREFIX . "thread AS thread ON(thread.threadid = post.threadid)
    WHERE post.iei_parsed=0
        $mwaimgcache_mwanotforumid
        $iei_ignore_usersp
        AND post.pagetext LIKE '%[/IMG]%'
    ORDER BY post.dateline DESC";

$rss = $vbulletin->db->query_read($SQL);
while($rs = $vbulletin->db->fetch_array($rss))
{
    $cnt++;
    if($cnt > $iei_max_post_count)
    {
        break;
    }
    if($cnt == 1)
    {
        // Cache registered images
        $images = iei_cache_registered_images();
    }

    $pagetext = $rs['pagetext'];

    // Find all embedded images
    if(!preg_match_all('/\[img.*?\](.*?)\[\/img\]/is', $pagetext, $matches))
    {
        $SQL = "UPDATE " . TABLE_PREFIX . "post 
            SET iei_parsed=1
            WHERE postid=$rs[postid]";
        $vbulletin->db->query_write($SQL);
        continue;
    }

    $changed = false;
    foreach($matches[1] as $key => $value)
    {
        $error = 0;

        // Search for images to be ignored
        $ignore = false;
        foreach($iei_ignore as $ivalue)
        {
            if($value && $ivalue && strpos($value, $ivalue) !== false)
            {
                $ignore = true;
                break;
            }
        }
        if($ignore)
        {
            continue;
        }

        // If we haven't got the image yet, download
        $filename = $images["$value"];
        $newimage = !$filename;
        while($newimage)
        {
            // Get file from remote site
            if(!$contents = iei_get_contents($value))
            {
                // Missing contents
                $error = 1;
                break;
            }

            // Get file extension
            iei_get_file_extension($value, $convert, $extension);

            // Make path
            $path = $iei_imported_images_folder . date('Y/m', $rs['dateline']);
            @mkdir($path, 0755, true);

            // Get file index
            $filename = iei_get_file_index($path, $extension);

            // See if we have valid contents
            if(!$im = @imagecreatefromstring($contents))
            {
                // Missing image or erroneous file image
                $error = 2;
            } elseif($convert)
            {
                // Convert image
                if(!@imagejpeg($im, $filename))
                {
                    // Error during saving
                    $error = 3;
                }
            }
            else
            {
                // Save it
                if(@file_put_contents($filename, $contents) === false)
                {
                    // Error during saving
                    $error = 4;
                }
            }
            @imagedestroy($im);
            break;
        }

        if($error)
        {
            // Missing image or erroneous file image
            if($iei_remove_invalid_images && $iei_invalid_image_replacement)
            {
                $filename = $iei_invalid_image_replacement;
                $error = 0;
            }
        }

        // If we have a new image, save it
        if($newimage)
        {
            $images["$value"] = $bburl . $filename;
            $oldurl = $vbulletin->db->escape_string($value);
            $newurl = $vbulletin->db->escape_string($images[$value]);
            $SQL = "INSERT IGNORE INTO " . TABLE_PREFIX . "iei_img (
                oldurl, 
                newurl
                ) VALUES (
                '$oldurl', 
                '$newurl'
                )";
            $vbulletin->db->query_write($SQL);
        }

        if(!$error)
        {
            // Replace this image
            $changed = true;
            $pagetext = str_replace($matches[0][$key], '[img]' . $images[$value] . '[/img]', $pagetext);
        }
    }

    if($changed)
    {
        $pagetext = $vbulletin->db->escape_string($pagetext);
        $SQL = "UPDATE " . TABLE_PREFIX . "post 
            SET pagetext='$pagetext', 
                iei_parsed=1
            WHERE postid=$rs[postid]";
        $fmt = 'Changed Post: ';
    }
    else
    {
        $SQL = "UPDATE " . TABLE_PREFIX . "post 
            SET iei_parsed=1
            WHERE postid=$rs[postid]";
        $fmt = 'Unchanged Post: ';
    }
    $fmt .= '<a href="%s/showthread.php?p=%d#post%d" target="_blank">%d</a>';
    $msg = sprintf($fmt, $bburl0, $rs['postid'], $rs['postid'], $rs['postid']);
    $vbulletin->db->query_write($SQL);
    if($changed)
    {
        $SQL = "DELETE 
            FROM " . TABLE_PREFIX . "postparsed 
            WHERE postid=$rs[postid]";
        $vbulletin->db->query_write($SQL);
    }
    log_cron_action($msg, $nextitem);
}
